/*

Simple Dynamic Clouds - shader example by Alexander Plloth ('Kartoffel')

*/

#include <acknex.h>
#include <d3d9.h>

var cloud_size = 10;

MATERIAL* MAT_clouds=
{
	effect = "clouds_subtract.fx";
}

action clouds()
{
	set(me,UNLIT | TRANSLUCENT);
	my.layer = 5;
	my.ambient = 100;
	my.alpha = 40; // overall alpha; more then 50 will work but it's too much
	my.albedo = 100; // cloud change speed; 50 looks good - I set it higher, to make the effect better visible
	my.material = MAT_clouds;
	vec_fill(my.scale_x,cloud_size); // Apply the size of the cloud-entity
	my.scale_z *= 1.25;
	my.red = 245; // cloud color / brightness can be changed with entity.red / green / blue
	my.green = 245;
	my.blue = 245;
}

ENTITY* sky=
{
	type = "sky.mdl";
	flags2 = SKY | SHOW;
	flags = SHOW | UNLIT;
	layer = 0;
}

void main()
{
	video_set(sys_metrics(0),sys_metrics(1),0,1);
	level_load(NULL);
	wait(1);
	camera.arc = 65;
	
	fps_max = 60;
	
	ent_create("clouds.mdl",nullvector,clouds); // Cloud entity
	
	while(key_esc != 1) // Turn Camera | Exit with [Esc]
	{
		camera.pan -= mickey.x / 5;
		camera.tilt -= mickey.y / 5;
		wait(1);
	}
	
	sys_exit(NULL);
}